set more off
global path_in ""
global path_temp ""
global path_out ""


*	Makes Table 2.

**1. Final three columns of Table 2
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/
	
	*create panel structure
	tsset cross year
	
	*Set productivity measure as country leave-out TFP
	local LP D1_lnTFPva_oth
		
	*Enforce productivity measure
	rename `LP' D1_LP1_EMP

	*Merge in country weights
	merge m:1 country using $path_in/country_weights
	drop _
	
	keep country code code_hier year weight_hrs weight_ls weight_TFP D1_lnH_EMP D1_lnlaborshare D1_LP1_EMP
	sort country code year
	*Calculate weighted means
	foreach var in D1_lnH_EMP D1_lnlaborshare D1_LP1_EMP {
		bysort country code: egen mean`var'=mean(`var') /*mean across years within countries*/
	}
	drop if D1_LP1_EMP==.
	duplicates drop country code, force
	bysort code: egen wtmean_hrs=sum(meanD1_lnH_EMP*weight_hrs)
	bysort code: egen wtmean_ls=sum(meanD1_lnlaborshare*weight_ls)
	bysort code: egen wtmean_TFP=sum(meanD1_LP1_EMP*weight_TFP)	
	
	duplicates drop code, force
	sort code_hier
	keep code wtmean*
	
**Save dataset containing final three columns of Table 2
	save $path_out\T2.dta, replace	
	

**2. First column of Table 2
use $path_in/industry_weights, clear
	list code share_w, clean
